/**
 * Get the correct product image URL based on hostname
 * Without a proper build system, temporary functionality to return a hardcoded URL based on window location to determine environment
 * @param originalUrl - The original product image URL
 * @returns The appropriate image URL for the current environment
 */
export function getProductImageUrl(originalUrl: string): string {
  if (
    typeof window !== 'undefined' &&
    window.location.hostname === 'www.kraken.bowler.family'
  ) {
    return 'https://www.kraken.bowler.family/philips-plumen.jpg';
  }
  return originalUrl;
}
