/**
 * Format price from pence to pounds sterling
 * @param pence - Price in pence (e.g., 1299)
 * @returns Formatted price string (e.g., "£12.99")
 */
export function formatPrice(pence: number): string {
  const pounds = pence / 100;
  return `£${pounds.toFixed(2)}`;
}
