import { getProductImageUrl } from '../getProductImageUrl';

describe('getProductImageUrl', () => {
  const originalUrl = 'https://example.com/product.jpg';
  const krakenUrl = 'https://www.kraken.bowler.family/philips-plumen.jpg';

  beforeEach(() => {
    // Reset window location
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    delete (window as any).location;
  });

  it('returns the Kraken URL when hostname is www.kraken.bowler.family', () => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (window as any).location = {
      hostname: 'www.kraken.bowler.family',
    };

    const result = getProductImageUrl(originalUrl);
    expect(result).toBe(krakenUrl);
  });

  it('returns the original URL when hostname is not www.kraken.bowler.family', () => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (window as any).location = {
      hostname: 'localhost',
    };

    const result = getProductImageUrl(originalUrl);
    expect(result).toBe(originalUrl);
  });

  it('returns the original URL when hostname is a different domain', () => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (window as any).location = {
      hostname: 'www.example.com',
    };

    const result = getProductImageUrl(originalUrl);
    expect(result).toBe(originalUrl);
  });

  it('handles empty string as original URL', () => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (window as any).location = {
      hostname: 'localhost',
    };

    const result = getProductImageUrl('');
    expect(result).toBe('');
  });
});
