import { formatPrice } from '../formatPrice';

describe('formatPrice', () => {
  it('formats zero pence correctly', () => {
    expect(formatPrice(0)).toBe('£0.00');
  });

  it('formats pence only amounts correctly', () => {
    expect(formatPrice(50)).toBe('£0.50');
    expect(formatPrice(99)).toBe('£0.99');
    expect(formatPrice(5)).toBe('£0.05');
  });

  it('formats standard prices correctly', () => {
    expect(formatPrice(1299)).toBe('£12.99');
    expect(formatPrice(2000)).toBe('£20.00');
    expect(formatPrice(999)).toBe('£9.99');
  });

  it('formats large amounts correctly', () => {
    expect(formatPrice(100000)).toBe('£1000.00');
    expect(formatPrice(123456)).toBe('£1234.56');
  });

  it('formats single pence correctly', () => {
    expect(formatPrice(1)).toBe('£0.01');
  });

  it('handles prices with decimal conversion', () => {
    expect(formatPrice(1550)).toBe('£15.50');
    expect(formatPrice(10025)).toBe('£100.25');
  });
});
