import React from 'react';
import { render, screen } from '@testing-library/react';
import { ProductSpecs } from '../ProductSpecs';

describe('ProductSpecs', () => {
  it('renders specifications title', () => {
    render(<ProductSpecs specifications={[]} />);
    expect(screen.getByText('Specifications')).toBeInTheDocument();
  });

  it('renders empty table when specifications array is empty', () => {
    render(<ProductSpecs specifications={[]} />);
    const table = screen.getByRole('table');
    expect(table).toBeInTheDocument();
    expect(table.querySelectorAll('tr').length).toBe(0);
  });

  it('renders specification rows with labels and values', () => {
    const specs = [
      { label: 'Power', value: '3kW' },
      { label: 'Dimensions', value: '100x50x50cm' },
      { label: 'Weight', value: '10kg' },
    ];
    render(<ProductSpecs specifications={specs} />);
    
    expect(screen.getByText('Power')).toBeInTheDocument();
    expect(screen.getByText('3kW')).toBeInTheDocument();
    expect(screen.getByText('Dimensions')).toBeInTheDocument();
    expect(screen.getByText('100x50x50cm')).toBeInTheDocument();
    expect(screen.getByText('Weight')).toBeInTheDocument();
    expect(screen.getByText('10kg')).toBeInTheDocument();
  });

  it('renders correct number of table rows', () => {
    const specs = [
      { label: 'Brand', value: 'Test Brand' },
      { label: 'Model', value: 'Test Model' },
    ];
    render(<ProductSpecs specifications={specs} />);
    
    const table = screen.getByRole('table');
    const rows = table.querySelectorAll('tbody tr');
    expect(rows.length).toBe(2);
  });

  it('renders single specification correctly', () => {
    const specs = [{ label: 'Color', value: 'Red' }];
    render(<ProductSpecs specifications={specs} />);
    
    expect(screen.getByText('Color')).toBeInTheDocument();
    expect(screen.getByText('Red')).toBeInTheDocument();
  });
});
