import React from 'react';
import { render, screen } from '@testing-library/react';
import { ProductCard } from '../ProductCard';

describe('ProductCard', () => {
  it('renders children correctly', () => {
    render(
      <ProductCard>
        <div>Product Content</div>
      </ProductCard>
    );
    expect(screen.getByText('Product Content')).toBeInTheDocument();
  });

  it('renders multiple children', () => {
    render(
      <ProductCard>
        <h1>Product Title</h1>
        <p>Product Description</p>
        <button>Add to Cart</button>
      </ProductCard>
    );
    expect(screen.getByText('Product Title')).toBeInTheDocument();
    expect(screen.getByText('Product Description')).toBeInTheDocument();
    expect(screen.getByText('Add to Cart')).toBeInTheDocument();
  });

  it('renders with correct className', () => {
    const { container } = render(
      <ProductCard>
        <span>Content</span>
      </ProductCard>
    );
    expect(container.firstChild).toHaveClass('card');
  });
});
