import React from 'react';
import { render } from '@testing-library/react';
import { LoadingSpinner } from '../LoadingSpinner';

describe('LoadingSpinner', () => {
  it('renders without crashing', () => {
    const { container } = render(<LoadingSpinner />);
    expect(container.firstChild).toBeInTheDocument();
  });

  it('renders the spinner element', () => {
    const { container } = render(<LoadingSpinner />);
    const spinnerElements = container.querySelectorAll('div');
    expect(spinnerElements.length).toBe(2); // Container + spinner
  });
});
