import React from 'react';
import styles from './QuantitySelector.module.css';

interface QuantitySelectorProps {
  value: number;
  onIncrement: () => void;
  onDecrement: () => void;
  min?: number;
  max?: number;
}

export function QuantitySelector({
  value,
  onIncrement,
  onDecrement,
  min = 1,
  max = 9,
}: QuantitySelectorProps) {
  const isMinReached = value <= min;
  const isMaxReached = value >= max;

  return (
    <div className={styles.container}>
      <button
        className={`${styles.button} ${styles.decrementButton}`}
        onClick={onDecrement}
        disabled={isMinReached}
        aria-label="Decrease quantity"
      >
        -
      </button>
      <span className={styles.value} title="Current quantity">
        {value}
      </span>
      <button
        className={`${styles.button} ${styles.incrementButton}`}
        onClick={onIncrement}
        disabled={isMaxReached}
        aria-label="Increase quantity"
      >
        +
      </button>
    </div>
  );
}
