import React from 'react';
import styles from './ProductSpecs.module.css';

interface Specification {
  label: string;
  value: string;
}

interface ProductSpecsProps {
  specifications: Specification[];
}

export function ProductSpecs({ specifications }: ProductSpecsProps) {
  return (
    <div className={styles.container}>
      <h2 className={styles.title}>Specifications</h2>
      <table className={styles.table}>
        <tbody>
          {specifications.map((spec, index) => (
            <tr key={index} className={styles.row}>
              <td className={styles.label}>{spec.label}</td>
              <td className={styles.value}>{spec.value}</td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}
