import baseConfig from './base.js';

// Export a function that consumers can call with their own createJestConfig
// This allows Next.js apps to provide their own next/jest instance
export default function createNextJestConfig(nextJestConfigFunc) {
  // Merge base config with Next.js-specific configuration
  const nextJestConfig = {
    ...baseConfig,
    moduleDirectories: ['node_modules', '<rootDir>/'],
    moduleNameMapper: {
      ...baseConfig.moduleNameMapper,
      '^@/(.*)$': '<rootDir>/$1',
    },
  };

  // Call the Next.js jest config function and return the result
  return nextJestConfigFunc(nextJestConfig);
}
