export default {
  testEnvironment: 'jest-environment-jsdom',
  setupFilesAfterEnv: ['@repo/jest-config/setup'],
  moduleNameMapper: {
    '\\.(css|less|scss|sass)$': 'identity-obj-proxy',
  },
  transform: {
    '^.+\\.(t|j)sx?$': [
      '@swc/jest',
      {
        jsc: {
          parser: {
            syntax: 'typescript',
            tsx: true,
          },
          transform: {
            react: {
              runtime: 'automatic',
            },
          },
        },
      },
    ],
  },
  extensionsToTreatAsEsm: ['.ts', '.tsx'],
  clearMocks: true,
  restoreMocks: true,
  // Coverage directory will be set per-project in the consuming package
  coverageThreshold: {
    global: {
      branches: 80,
      functions: 80,
      lines: 80,
      statements: 80,
    },
  },
  coveragePathIgnorePatterns: [
    '/node_modules/',
    '\\.d\\.ts$',
    '/index\\.ts$',
    '/__tests__/',
    '\\.test\\.',
    '\\.spec\\.',
  ],
};
