'use client';

import { ApolloClient, InMemoryCache, ApolloProvider } from '@apollo/client';
import { CartProvider } from '@repo/kraken-ui';
import { ReactNode } from 'react';

// Determine GraphQL URI based on hostname - production vs. development (quick fix for now)
const getGraphQLUri = () => {
  if (typeof window !== 'undefined') {
    if (window.location.hostname === 'www.kraken.bowler.family') {
      return 'https://www.kraken-api.bowler.family/graphql';
    }
  }
  return 'http://localhost:3001/graphql';
};

const client = new ApolloClient({
  uri: getGraphQLUri(),
  cache: new InMemoryCache(),
});

interface ProvidersProps {
  children: ReactNode;
}

export function Providers({ children }: ProvidersProps) {
  return (
    <ApolloProvider client={client}>
      <CartProvider>
        {children}
      </CartProvider>
    </ApolloProvider>
  );
}
