import Link from 'next/link';
import Image from 'next/image';
import fs from 'fs';
import path from 'path';
import ReactMarkdown from 'react-markdown';

export default function Home() {
  const readmePath = path.join(process.cwd(), '../../README.md');
  const readmeContent = fs.readFileSync(readmePath, 'utf8');

  return (
    <main>
      <div className="home">
        <figure>
          <Image
            src="/octopus-logo.svg"
            alt="Octopus Energy Logo"
            width={470}
            height={67}
          />
        </figure>
        <h1>Welcome to the Octopus Energy Frontend code test!</h1>
        <p style={{ marginBottom: '2rem', marginTop: '2rem' }}>
          <Link href="/product">
            Visit the Product Page
          </Link>
        </p>
        <p style={{ marginBottom: '2rem' }}>
          <a href="/kraken-code-challenge-jb.zip" download>
            Download Project Source Code
          </a>
        </p>
        <p>
          <a href="#readme">
            View README
          </a>
        </p>
      </div>
      <div id="readme" className="readme-container">
        <ReactMarkdown
          components={{
            h1: ({ children, ...props }) => <h1 id={children?.toString().toLowerCase().replace(/\s+/g, '-')} {...props}>{children}</h1>,
            h2: ({ children, ...props }) => <h2 id={children?.toString().toLowerCase().replace(/\s+/g, '-')} {...props}>{children}</h2>,
            h3: ({ children, ...props }) => <h3 id={children?.toString().toLowerCase().replace(/\s+/g, '-')} {...props}>{children}</h3>,
          }}
        >
          {readmeContent}
        </ReactMarkdown>
      </div>
    </main>
  );
}
