import type { Metadata } from 'next';
import '@repo/styles/globals.css';
import { Providers } from './providers';

export const metadata: Metadata = {
  title: 'Octopus Energy',
  icons: {
    icon: 'https://static.octopuscdn.com/favicons/favicon-32x32.png',
  },
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="en">
      <head>
        <link
          rel="stylesheet"
          type="text/css"
          href="https://static.octopuscdn.com/fonts/Gotham/fonts.min.css"
        />
      </head>
      <body>
        <Providers>{children}</Providers>
      </body>
    </html>
  );
}
