# README.md - Frontend Code Test - submission
### James Bowler | james@bowler.family | www.kraken.bowler.family

## Table of Contents
- [Hosting note](#hosting-note)
- [Quick start](#quick-start)
  - [Pre-requisits](#pre-requisits)
  - [Installing PNPM](#installing-pnpm)
  - [Local Setup](#local-setup)
  - [Additional commands](#additional-commands)
- [Project structure](#project-structure)
- [Technologies](#technologies)
  - [Frontend](#frontend)
  - [Backend](#backend)
  - [Development Tools](#development-tools)
  - [Runtime](#runtime)
- [Rationale](#rationale)
  - [Assumptions](#assumptions)
  - [Monorepo Architecture](#monorepo-architecture)
  - [CSS Setup](#css-setup)
  - [Git Strategy](#git-strategy)

## Hosting note

For the purposes of this coding test, this project is hosted at
- www.kraken.bowler.family

A git repository is available for download as a zip file. It can be made available on github on request.

## Quick start

This is a turborepo project using pnpm package manager.

### Pre-requisits

- Node.js >= v24.11.1
- PNPM >= 9.0.0 (package manager)

### Installing PNPM

Option 1 - Using NPM (recommended)
```bash
npm install -g pnpm
```
Option 2 - Using Corepack
```bash
corepack enable
corepack prepare pnpm@latest --activate
```

### Local Setup

1. Extract the zip file

2. Install dependencies:

```bash
pnpm install
```

3. Build all packages:
```bash
pnpm run build
```

4. Run dev:
```bash
pnpm run dev
```

### Additional commands

- Run tests:
```bash
pnpm run test
```

- Run linter:
```bash
pnpm run lint
```

- Run prettier check:
```bash
pnpm run format:check
```

## Project structure

```
apps/
├── kraken-client/          # Next.js frontend application
└── kraken-server/          # Backend server

packages/
├── eslint-config/          # Shared ESLint configurations
├── graphql-types/          # GraphQL type definitions and codegen
├── jest-config/            # Shared jest configurations
├── kraken-ui/              # Shared React component library
├── styles/                 # Shared styles and theme
└── typescript-config/      # Shared TypeScript configurations
```

## Technologies

### Frontend
- **Next.js** v15 - React framework
- **React** v19 - UI library
- **TypeScript** v5.7 - Type-safe JavaScript
- **Apollo Client** v3.7 - GraphQL client
- **CSS Modules** - Component styling

### Backend
- **GraphQL** v16 - API query language
- **JSON GraphQL Server** v2.3 - Mock server

### Development Tools
- **Turborepo** v2.6 - Monorepo build system
- **PNPM** v9 - Package manager
- **GraphQL Code Generator** v5 - Type generation
- **Jest** v29 - Testing framework
- **Testing Library** v16 - React testing utilities
- **ESLint** v9 - Code linting
- **Prettier** v3.6 - Code formatting

### Runtime
- **Node.js** v24

## Rationale

I set out to demonstrate my ability to architect complex, scalable applications, designed to reduce code duplication and enforce consistency across multiple projects. The pattern I've choosen is based on experience, with code snippets and configuration taken from personal projects. 

Given a self imposed time constraint, shortcuts have been made in the design and implementation; which would typically be addressed before using this in a production grade system.

I approached this task in a similar way as when setting up a new project for a new team, applying various assumptions and a significant time constraint.

### Assumptions

- The technology to be used and architecture has already been discussed and accepted with stakeholders
- This first submission is a prototype, evolving into MVP and beyond
- As a new project, there is flexibility choosing technologies and tooling
- AI tools permitted
  - Claude Sonnet 4.5 used in VSCode for auto code complete and boilerplating
- The design image represents a mobile view, to be taken as an approximate representation for sizing and spacing

### Monorepo Architecture

This project uses a monorepo structure with Turborepo to efficiently manage multiple applications and shared packages.

Starting this structure on a small project allows the project to continuously scale, with all developers on the project familiar with the structure from day 1. This structure is worth considering in an environment using multiple front end and/or back end applications - e.g. a micro service architecture. 

- **Code Reusability** - Shared UI components (`kraken-ui`), configurations (`eslint-config`, `typescript-config`), and utilities are used across both client and server
- **Type Safety** - GraphQL types (`graphql-types`) are generated once and shared, ensuring consistency between frontend and backend
- **Consistent Tooling** - Single source of truth for linting, formatting, and TypeScript configs across all apps. Particulalry useful when multiple teams work on the project

### CSS Setup

For simplicity, I haven't implemented SCSS in this project.

I've choosen to use CSS modules, as opposed to a css framework like tailwind. CSS modules makes it easier to implement brand heavy, highly customised visuals. CSS being located alongside components makes it easier to locate relevant styling and scoped styles prevents naming conflicts.

### Git Strategy

Github flow is used on this repository (https://docs.github.com/en/get-started/using-github/github-flow)

`main` branch represents production ready code. Branches should be prefixed with `fix/`, `feature/`, `test/` or `chore/` depending on the intent. 
